// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'DFCtrls.pas' rev: 5.00

#ifndef DFCtrlsHPP
#define DFCtrlsHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <NumMan.hpp>	// Pascal unit
#include <DrawMan.hpp>	// Pascal unit
#include <ColorMan.hpp>	// Pascal unit
#include <Backgnd.hpp>	// Pascal unit
#include <DFClasses.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Dfctrls
{
//-- type declarations -------------------------------------------------------
typedef Shortint TBevelSize;

#pragma option push -b-
enum TBevelType { btNone, btWindows95, btFlat3D, btIE4Interactive, bt2DRect };
#pragma option pop

class DELPHICLASS TDFBevel;
class PASCALIMPLEMENTATION TDFBevel : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TBevelType fType;
	TBevelSize fSize;
	Graphics::TColor fColor;
	Classes::TNotifyEvent fOnChange;
	void __fastcall SetType(TBevelType Val);
	void __fastcall SetSize(TBevelSize Val);
	void __fastcall SetColor(Graphics::TColor Val);
	
public:
	HIDESBASE void __fastcall Assign(TDFBevel* Value);
	void __fastcall Changed(void);
	
__published:
	__property TBevelType BevelType = {read=fType, write=SetType, nodefault};
	__property TBevelSize Size = {read=fSize, write=SetSize, nodefault};
	__property Graphics::TColor Color = {read=fColor, write=SetColor, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=fOnChange, write=fOnChange};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TDFBevel(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TDFBevel(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


class DELPHICLASS TDFControl;
class PASCALIMPLEMENTATION TDFControl : public Dfclasses::TDFGraphicControl 
{
	typedef Dfclasses::TDFGraphicControl inherited;
	
private:
	Backgnd::TBackgndObj* fBackground;
	TDFBevel* fBevel;
	bool fFocused;
	Windows::TRect fPaintRect;
	Classes::TNotifyEvent fMouseEnter;
	Classes::TNotifyEvent fMouseLeave;
	bool fMouseOver;
	void __fastcall SetBackground(Backgnd::TBackgndObj* Val);
	void __fastcall SetBevel(TDFBevel* Val);
	void __fastcall SetFocused(bool Val);
	void __fastcall BackChanged(System::TObject* Sender);
	void __fastcall BevelChanged(System::TObject* Sender);
	MESSAGE void __fastcall MsgMouseEnter(Messages::TMessage &Message);
	MESSAGE void __fastcall MsgMouseLeave(Messages::TMessage &Message);
	
protected:
	DYNAMIC void __fastcall PaintBackup(void);
	DYNAMIC void __fastcall MouseEnter(void);
	DYNAMIC void __fastcall MouseLeave(void);
	__property Backgnd::TBackgndObj* Background = {read=fBackground, write=SetBackground};
	__property TDFBevel* Bevel = {read=fBevel, write=SetBevel};
	__property Windows::TRect PaintRect = {read=fPaintRect, write=fPaintRect};
	__property bool Focused = {read=fFocused, write=SetFocused, nodefault};
	__property bool MouseOver = {read=fMouseOver, nodefault};
	__property Classes::TNotifyEvent OnMouseEnter = {read=fMouseEnter, write=fMouseEnter};
	__property Classes::TNotifyEvent OnMouseLeave = {read=fMouseLeave, write=fMouseLeave};
	
public:
	__fastcall virtual TDFControl(Classes::TComponent* AOwner);
	__fastcall virtual ~TDFControl(void);
};


class DELPHICLASS TApples;
class PASCALIMPLEMENTATION TApples : public TDFControl 
{
	typedef TDFControl inherited;
	
private:
	Graphics::TBitmap* FApple;
	bool FLineWrap;
	Graphics::TColor FTransparentColor;
	Extended FValue;
	void __fastcall SetApple(Graphics::TBitmap* Val);
	void __fastcall SetLineWrap(bool Val);
	void __fastcall SetTransparentColor(Graphics::TColor Val);
	void __fastcall SetValue(Extended Val);
	
protected:
	DYNAMIC void __fastcall PaintBackup(void);
	
public:
	__fastcall virtual TApples(Classes::TComponent* AOwner);
	__fastcall virtual ~TApples(void);
	
__published:
	__property Graphics::TBitmap* Apple = {read=FApple, write=SetApple};
	__property bool LineWrap = {read=FLineWrap, write=SetLineWrap, nodefault};
	__property Graphics::TColor TransparentColor = {read=FTransparentColor, write=SetTransparentColor, 
		nodefault};
	__property Extended Value = {read=FValue, write=SetValue};
	__property Backgnd::TBackgndObj* Background = {read=fBackground, write=SetBackground};
	__property TDFBevel* Bevel = {read=fBevel, write=SetBevel};
	__property Classes::TNotifyEvent OnMouseEnter = {read=fMouseEnter, write=fMouseEnter};
	__property Classes::TNotifyEvent OnMouseLeave = {read=fMouseLeave, write=fMouseLeave};
	__property Align ;
	__property Enabled ;
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
};


#pragma option push -b-
enum TDFScrollEvent { seNone, seIncClick, seDecClick, sePageUp, sePageDown, seDragThumb };
#pragma option pop

#pragma option push -b-
enum TDFScrollOrientation { soHorizontal, soVertical };
#pragma option pop

class DELPHICLASS TDFScroll;
class PASCALIMPLEMENTATION TDFScroll : public TDFControl 
{
	typedef TDFControl inherited;
	
private:
	Graphics::TBitmap* fUp;
	Graphics::TBitmap* fDown;
	Graphics::TBitmap* fLeft;
	Graphics::TBitmap* fRight;
	Graphics::TBitmap* fThumb;
	int fMax;
	int fMin;
	int fPosition;
	int fLargeChange;
	int fSmallChange;
	Classes::TNotifyEvent fOnChange;
	TDFScrollOrientation fOrientation;
	bool fMouseDown;
	Windows::TPoint fThumbDrag;
	Byte fGlyphs;
	TDFScrollEvent fCurrEvent;
	bool fThumbTrans;
	void __fastcall SetUp(Graphics::TBitmap* Val);
	void __fastcall SetDown(Graphics::TBitmap* Val);
	HIDESBASE void __fastcall SetLeft(Graphics::TBitmap* Val);
	void __fastcall SetRight(Graphics::TBitmap* Val);
	void __fastcall SetThumb(Graphics::TBitmap* Val);
	void __fastcall SetMax(int Val);
	void __fastcall SetMin(int Val);
	void __fastcall SetPosition(int Val);
	void __fastcall SetGlyphs(Byte Val);
	void __fastcall SetThumbTrans(bool Val);
	void __fastcall SetOrientation(TDFScrollOrientation Val);
	void __fastcall OnTimer(System::TObject* Sender);
	
protected:
	DYNAMIC void __fastcall PaintBackup(void);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	virtual Windows::TRect __fastcall DecBox();
	virtual Windows::TRect __fastcall IncBox();
	virtual Windows::TRect __fastcall ThumbBox();
	virtual Windows::TPoint __fastcall PosToPoint(int Pos);
	virtual int __fastcall PointToPos(const Windows::TPoint &Point);
	
public:
	__fastcall virtual TDFScroll(Classes::TComponent* AOwner);
	__fastcall virtual ~TDFScroll(void);
	void __fastcall PageUp(void);
	void __fastcall PageDown(void);
	void __fastcall Increment(void);
	void __fastcall Decrement(void);
	void __fastcall ScrollBy(int X, int Y);
	
__published:
	__property Graphics::TBitmap* Pic_Up = {read=fUp, write=SetUp};
	__property Graphics::TBitmap* Pic_Down = {read=fDown, write=SetDown};
	__property Graphics::TBitmap* Pic_Left = {read=fLeft, write=SetLeft};
	__property Graphics::TBitmap* Pic_Right = {read=fRight, write=SetRight};
	__property Graphics::TBitmap* Pic_Thumb = {read=fThumb, write=SetThumb};
	__property int Max = {read=fMax, write=SetMax, default=100};
	__property int Min = {read=fMin, write=SetMin, default=0};
	__property int Position = {read=fPosition, write=SetPosition, default=0};
	__property int LargeChange = {read=fLargeChange, write=fLargeChange, default=1};
	__property int SmallChange = {read=fSmallChange, write=fSmallChange, default=1};
	__property Byte NumGlyph = {read=fGlyphs, write=SetGlyphs, default=1};
	__property bool TransparentThumb = {read=fThumbTrans, write=SetThumbTrans, default=0};
	__property TDFScrollOrientation Orientation = {read=fOrientation, write=SetOrientation, default=0};
		
	__property Backgnd::TBackgndObj* Background = {read=fBackground, write=SetBackground};
	__property TDFBevel* Bevel = {read=fBevel, write=SetBevel};
	__property Classes::TNotifyEvent OnMouseEnter = {read=fMouseEnter, write=fMouseEnter};
	__property Classes::TNotifyEvent OnMouseLeave = {read=fMouseLeave, write=fMouseLeave};
	__property Classes::TNotifyEvent OnChange = {read=fOnChange, write=fOnChange};
	__property Align ;
	__property Enabled ;
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
};


#pragma option push -b-
enum TDrawStyle { dsNone, dsClient, dsCentered };
#pragma option pop

#pragma option push -b-
enum TColorOption { coNone, coTransparent, coSmoothed };
#pragma option pop

class DELPHICLASS TBCBitmap;
class PASCALIMPLEMENTATION TBCBitmap : public TDFControl 
{
	typedef TDFControl inherited;
	
private:
	bool FAutoSize;
	Graphics::TBitmap* FPicture;
	TDrawStyle FStyle;
	TColorOption FColorOption;
	bool FInvert;
	bool FMouseDown;
	Graphics::TBitmap* FSmoothed;
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	void __fastcall SetPicture(Graphics::TBitmap* Val);
	void __fastcall SetStyle(TDrawStyle Val);
	void __fastcall SetColorOption(TColorOption Val);
	HIDESBASE void __fastcall SetAutoSize(bool Val);
	
protected:
	DYNAMIC void __fastcall PaintBackup(void);
	
public:
	__fastcall virtual TBCBitmap(Classes::TComponent* AOwner);
	__fastcall virtual ~TBCBitmap(void);
	__property Canvas ;
	
__published:
	__property Graphics::TBitmap* Picture = {read=FPicture, write=SetPicture};
	__property TDrawStyle DrawStyle = {read=FStyle, write=SetStyle, nodefault};
	__property TColorOption ColorOption = {read=FColorOption, write=SetColorOption, nodefault};
	__property bool InvertImageOnMouseDown = {read=FInvert, write=FInvert, nodefault};
	__property bool AutoSize = {read=FAutoSize, write=SetAutoSize, default=0};
	__property Backgnd::TBackgndObj* Background = {read=fBackground, write=SetBackground};
	__property TDFBevel* Bevel = {read=fBevel, write=SetBevel};
	__property Classes::TNotifyEvent OnMouseEnter = {read=fMouseEnter, write=fMouseEnter};
	__property Classes::TNotifyEvent OnMouseLeave = {read=fMouseLeave, write=fMouseLeave};
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall PaintBevel(Graphics::TCanvas* Canvas, Windows::TRect &Rect, TDFBevel* 
	Bevel, bool Focused);

}	/* namespace Dfctrls */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Dfctrls;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// DFCtrls
